% order_log.m
% Example of a four channel Order Ratio measurement 
% hit "Control c" to exit
% REV 11/10_97
clear all;



%  make the following 1 thru the number of h/w channels that exist 
OLDCHANNELS = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16];
              %list above all h/w channels
CHANNELS  = [1 2 3 4];            %  list of active channels
NUM_CHAN = size(CHANNELS);
GLOBAL_CHS = [1 2 3 4 8193 8194];
TACH_CHS = [8193 8194];
TACH_0 = 8193;
TACH_1 = 8194;
BLOCKSIZE = 1024;  %hardcode blocksize until interdependence taken care of

% Get user interface values
%BLOCKSIZE = str2num(get(findobj('tag','Blocksize'),'string'))
L_LEVEL = str2num(get(findobj('tag','Low Trigger Level'),'string'));
U_LEVEL = str2num(get(findobj('tag','Upper Trigger Level'),'string'));
DELTA_ORDER = str2num(get(findobj('tag','Delta Order'),'string'));
RPM_LOW = str2num(get(findobj('tag','Start RPM'),'string'));
RPM_HIGH = str2num(get(findobj('tag','End RPM'),'string'));
MAX_ORDER = str2num(get(findobj('tag','Max Order'),'string'));
RPM_INT = str2num(get(findobj('tag','RPM Interval'),'string'));
TACH_PPR = str2num(get(findobj('tag','Tach_ppr'),'string'));
RANGE = str2num(get(findobj('tag','Input V Range'),'string'));
DISPLAY_CH = str2num(get(findobj('tag','Display Ch (1-4)'),'string'));

figure(3);

O=DELTA_ORDER:DELTA_ORDER:MAX_ORDER-DELTA_ORDER;  % build order array values
O=O';                                            % Transpose array


% Note:  This simple example doesn't check for the interdependent nature of the
%        parameters.  For example,the Max order / delta order is coupled to the blocksize.

[status,session] = hpe1432('init','VXI0::8::INSTR',1,1);  % use vxi module at address 8

[status] = hpe1432('deleteAllChanGroups',session);
   %create a group of all physical channels and then turn them off in case some previous
   %activity left them on
[status,gid] = hpe1432('createChannelGroup',session,length(OLDCHANNELS),OLDCHANNELS);
[status] = hpe1432('setActive',session,gid,'CHANNEL_OFF');
   %start fresh and create a group of just the channels that will be active
[status] = hpe1432('deleteAllChanGroups',session);
[status,gid] = hpe1432('createChannelGroup',session,length(CHANNELS),CHANNELS);
   %Create a group of just the tachs
[status,gid_tach] = hpe1432('createChannelGroup',session,length(TACH_CHS),TACH_CHS);
   %Create a global group of inputs and tachs
[status,gid_global] = hpe1432('createChannelGroup',session,length(GLOBAL_CHS),GLOBAL_CHS);

   %Setup inputs
[status] = hpe1432('setActive',session,gid,'CHANNEL_ON');
[status] = hpe1432('setInputMode',session,gid,'INPUT_MODE_VOLT');
[status] = hpe1432('setInputHigh',session,gid,'INPUT_HIGH_NORMAL');
[status] = hpe1432('setAntiAliasAnalog',session,gid,'ANTI_ALIAS_ANALOG_ON');
[status] = hpe1432('setDataSize',session,gid,'DATA_SIZE_32');
[status] = hpe1432('setDataMode',session,gid,'DATA_MODE_OVERLAP_BLOCK');
[status] = hpe1432('setRange',session,gid,RANGE);
[status] = hpe1432('setBlocksize',session,gid,BLOCKSIZE);
[status,actual_blocksize] = hpe1432('getBlocksize',session,gid);

actual_blocksize = double(actual_blocksize);

BLOCK_SIZE_2 = -1 *(actual_blocksize / 2);

%Setup tachs
[status] = hpe1432('setActive',session,gid_tach,'CHANNEL_ON');
[status] = hpe1432('setTriggerLevel',session,gid_tach,'TRIGGER_LEVEL_LOWER',L_LEVEL);
[status] = hpe1432('setTriggerLevel',session,gid_tach,'TRIGGER_LEVEL_UPPER',U_LEVEL);
[status] = hpe1432('setPreArmMode',session,gid_tach,'AUTO_ARM');
[status] = hpe1432('setArmMode',session,gid_tach,'ARM_RPM_RUNUP');
[status] = hpe1432('setAutoTrigger',session,gid_tach,'AUTO_TRIGGER');
[status] = hpe1432('setDeltaOrder',session,gid_tach,DELTA_ORDER);
[status] = hpe1432('setRpmLow',session,gid_tach,RPM_LOW);
[status] = hpe1432('setRpmHigh',session,gid_tach,RPM_HIGH);
[status] = hpe1432('setMaxOrder',session,gid_tach,MAX_ORDER);
[status] = hpe1432('setTachPpr',session,gid_tach,TACH_PPR);
[status] = hpe1432('setRpmInterval',session,gid_tach,RPM_INT);
[status] = hpe1432('setTriggerChannel',session,gid_tach,'CHANNEL_ON');
[status] = hpe1432('setTriggerDelay',session,gid_tach,BLOCK_SIZE_2);

% Set input data mode

[status] = hpe1432('setCalcData',session,gid,'DATA_RESAMP_TIME');
[status] = hpe1432('setDecimationOutput',session,gid,'MULTI_PASS');
[status] = hpe1432('setDecimationOversample',session,gid,'DECIMATION_OVERSAMPLE_ON');

% Set Arm Channel

[status] = hpe1432('setArmChannel',session,TACH_0,'CHANNEL_ON');

% Additional Input setup

MAX_SPAN = RPM_HIGH * MAX_ORDER / 60;

[status] = hpe1432('setSpan',session,gid,MAX_SPAN);
[status,actual_span] = hpe1432('getSpan',session,gid);
[status] = hpe1432('finishMeasure',session,gid_global);


% Start measurement

[status] = hpe1432('initMeasure',session,gid_global);
pause(3);

   % Get Initial RPM's
[status,current_rpm_0] = hpe1432('getCurrentRpm',session,TACH_0);
[status,current_rpm_1] = hpe1432('getCurrentRpm',session,TACH_1);

current_rpm_0
current_rpm_1;

A=1;
data_time = 0;
data_resamp = 0;
data_rpm = 0;
current_rpm = 0;

hold off;
t0=clock;       % Timing measurement performance
while A>0,
   
% Wait for block available
[status, blockAvailable] = hpe1432('blockAvailable',session,TACH_0);

blockAvailable = double(blockAvailable);           % Convert format
   if blockAvailable > 0
   
       [status,current_rpm] = hpe1432('getDataRpm',session,TACH_0);
       current_rpm           % print rpm value
       data_rpm = [data_rpm;current_rpm];    % add new rpm value to data_rpm array
       [status,nextArmRpm] = hpe1432('getNextArmRpm',session,TACH_0);
       [status,data_t,count_t] = hpe1432('readFloat64Data',session,gid,'TIME_DATA',BLOCKSIZE*length(CHANNELS),'WAIT_FLAG');
       [status,data_r,count_r] = hpe1432('readFloat64Data',session,gid,'RESAMP_DATA',BLOCKSIZE*length(CHANNELS),'WAIT_FLAG');
              
       data_time = [data_time;data_t];               % add new record data_t to data_time array
       data_resamp = [data_resamp;data_r];          % add new record data_r to data_resamp array
       % A=A+1    % let user know loop is working
    end
    
    if current_rpm == (RPM_HIGH - RPM_INT)  % Test to see if done with last RPM
       A=0;                                 % Done !
       
    etime(clock,t0)                       % Timing measurement   
    end
    
 end             % end while loop
 [status] = hpe1432('finishMeasure',session, gid);
 [status] = hpe1432('close',session);
 B=0;
 
 %plot order ratio map
 data_rpm = data_rpm(2:size(data_rpm));  %remove 0 rpm data 
 num_rpm = size(data_rpm);
 data_resamp = data_resamp(2:size(data_resamp));  %remove 0 rpm data

 ord_time=reshape(data_resamp,actual_blocksize,NUM_CHAN(1,2), num_rpm(1));
 t11= clock;
 z1=fft(ord_time);           % One dimensional fft of the 3-D matrix (revolution
                             % domain samples, channels, rpm internals)
 etime(clock,t11)            % fft time for all rpms
 z1=z1./actual_blocksize;     % scale data by blocksize
 z2=z1.*conj(z1);           % get magnitude
 z3=z2(2:size(O)+1,:,:);       % save first 'O' values of order data but remove DC term
 z3a=permute(z3,[1,3,2]);  % rearrange matrix (swap 2 with 3)
 z4=10*log10(z3);
 z4a=permute(z4,[1,3,2]);
 
 figure(3) % create figure 2
 surf(data_rpm,O,z4a(:,:,DISPLAY_CH)),drawnow;  % Plot rpm vs orders vs order data for ch 1
 view(115,30);
 shading interp, drawnow;
 title ('Matlab based Order Ratio Map')
 xlabel ('RPM')
 ylabel ('Order')
 
 figure(2);
 pcolor(data_rpm,O,z4a(:,:,DISPLAY_CH)), drawnow;
 view(90,-90);
 shading interp, drawnow ;
 title ('Matlab based Order Ratio Map')
 xlabel ('RPM')
 ylabel ('Order')
 
 
